import math as m
import time
import muriArrayV2

class muriTileV2:
    def __init__(self,address,coordinates, spi_controller):
        self.address = address
        self.spi_channel = spi_controller # Spi controller instance
        self.coordinates = coordinates
        print "Tile Created: Address " + str(self.address) + " @ " + str(self.coordinates)

    def enableRF(self,verbose=False):
        metadata = 1
        command = 32
        data = [metadata, self.address, command]
        self.spi_channel.sendData(data,verbose)

    def disableRF(self,verbose=False):
        metadata = 1
        command = 16
        data = [metadata, self.address, command]
        self.spi_channel.sendData(data,verbose)

    def programOutputPower(self,p_out,verbose=False):
        metadata = 65
        command = 2
        data = [metadata, self.address, command, p_out]
        self.spi_channel.sendData(data,verbose)

    # Phase is in units of one hundredth of a degree
    # 0 <= phase < 360
    # rfEnable option lets one command also turn on rf if it is off
    # this is useful during phase optimization
    def programPhase(self,phase_deg,rfEnable = False,verbose=False):
        metadata = 129
        command = 4
        if rfEnable:
            command += 32
        data = [metadata, self.address, command]
        data += muriArrayV2.muriArrayV2.convertPhaseToBytes(phase_deg)
        self.spi_channel.sendData(data,verbose)

    def enableMetagaps(self,verbose=False):
        metadata = 1
        command = 128
        data = [metadata, self.address, command]
        self.spi_channel.sendData(data,verbose)

    def disableMetagaps(self,verbose=False):
        metadata = 1
        command = 64
        data = [metadata, self.address, command]
        self.spi_channel.sendData(data)

    def turnOnAllMetagaps(self,verbose=False):
        on_state = int("FFFFFF",16)
        self.programMetagaps(on_state,verbose)

    # mg data is a state number
    def programMetagaps(self,mg_data_e,mg_data_h=None,verbose=False):
        metadata = 33
        command = 8
        data = [metadata, self.address, command]
        data += muriArrayV2.muriArrayV2.convertMetagapStateToBytes(mg_data_e)
        if mg_data_h is not None:
            data += muriArrayV2.muriArrayV2.convertMetagapStateToBytes(mg_data_h)
        else:
            data += muriArrayV2.muriArrayV2.convertMetagapStateToBytes(mg_data_e)
        self.spi_channel.sendData(data,verbose)

    # command is command data byte
    # phase data is in degrees
    # mg data is a state number
    def directProgram(self,command,phase_data = None,power_data = None,mg_data_e = None, mg_data_h= None,verbose=False):
        program_phase = (phase_data is not None)
        program_power = (power_data is not None)
        program_mg = (mg_data_e is not None)
        metadata = muriArrayV2.muriArrayV2.getPacketMetadata(1,program_phase,program_power,program_mg)

        data = [metadata, self.address, command]
        if program_phase:
            data += muriArrayV2.muriArrayV2.convertPhaseToBytes(phase_data)
        if program_mg:
            data += muriArrayV2.muriArrayV2.convertMetagapStateToBytes(mg_data_e)
            if mg_data_h is not None:
                data += muriArrayV2.muriArrayV2.convertMetagapStateToBytes(mg_data_h)
            else:
                data += muriArrayV2.muriArrayV2.convertMetagapStateToBytes(mg_data_e)
        if program_power:
            data += [power_data]
        self.spi_channel.sendData(data,verbose)
